/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.File;
import java.util.List;
import java.util.Map;
import panther.util.general.BufferedProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSUtil {
    public static Process buildProcess(Map<String, String> map, File file, boolean bl, String ... stringArray) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        return OSUtil.completeBuilder(processBuilder, map, file, bl);
    }

    public static Process buildProcess(Map<String, String> map, File file, boolean bl, List<String> list) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        return OSUtil.completeBuilder(processBuilder, map, file, bl);
    }

    public static BufferedProcess buildBufferedProcess(List<String> list) throws Exception {
        return OSUtil.buildBufferedProcess(null, null, false, list);
    }

    public static BufferedProcess buildBufferedProcess(String ... stringArray) throws Exception {
        return OSUtil.buildBufferedProcess(null, null, false, stringArray);
    }

    public static BufferedProcess buildBufferedProcess(Map<String, String> map, File file, boolean bl, List<String> list) throws Exception {
        Process process = OSUtil.buildProcess(map, file, bl, list);
        return new BufferedProcess(process, bl);
    }

    public static BufferedProcess buildBufferedProcess(Map<String, String> map, File file, boolean bl, String ... stringArray) throws Exception {
        Process process = OSUtil.buildProcess(map, file, bl, stringArray);
        return new BufferedProcess(process, bl);
    }

    public static int chmod(File file, String string) throws Exception {
        return OSUtil.chmod(file.getAbsolutePath(), string);
    }

    public static int chmod(String string, String string2) throws Exception {
        return OSUtil.exec("chmod " + string2 + " " + string).exitValue();
    }

    public static Process exec(String string) throws Exception {
        Process process = Runtime.getRuntime().exec(string);
        process.waitFor();
        return process;
    }

    protected static Process completeBuilder(ProcessBuilder processBuilder, Map<String, String> map, File file, boolean bl) throws Exception {
        if (map != null && !map.isEmpty()) {
            Map<String, String> map2 = processBuilder.environment();
            for (String string : map.keySet()) {
                map2.put(string, map.get(string));
            }
        }
        if (file != null && file.exists()) {
            processBuilder = processBuilder.directory(file);
        }
        if (bl) {
            processBuilder = processBuilder.redirectErrorStream(true);
        }
        return processBuilder.start();
    }
}

